import requests
import json
from flask import Flask, render_template, request

app = Flask(__name__)

@app.route('/', methods=['GET', 'POST'])
def index():
  memo = ''
  result = ''
  if request.method == 'POST':
    # フォームが送信された場合
    memo = request.form['memo']
    result = api(memo)
  return render_template('index.html', memo=memo, result=result)

def api(memo):
  api_endpoint = "http://localhost/v1/workflows/run" # APIエンドポイント
  api_key = "app-xxx" # Dify APIキー
  user_id = "python-test-user-003"

  headers = {
    "Authorization": f"Bearer {api_key}",
    "Content-Type": "application/json"
  }

  data = {
    "inputs": {
      "memo_text": memo # 開始ノードで定義した変数名に合わせる
    },
    "response_mode": "blocking", # または "streaming"
    "user": user_id
  }

  try:
    response = requests.post(api_endpoint, headers=headers, json=data)
    response.raise_for_status() # エラーがあれば例外を発生させる

    result = response.json()

    # 回答部分を取り出す (レスポンスの構造に合わせて調整が必要)
    answer = result["data"]["outputs"]
    if answer:
      return json.dumps(answer, indent=2, ensure_ascii=False)

  except requests.exceptions.RequestException as e:
    print(f"API呼び出しエラー: {e}")
    if e.response is not None:
      print(f"ステータスコード: {e.response.status_code}")
      try:
        print(f"エラー詳細: {e.response.json()}")
      except json.JSONDecodeError:
        print(f"エラー詳細 (テキスト): {e.response.text}")
  return 'no result...'

if __name__ == '__main__':
  app.run(debug=True, port=5100)

# python app.py
# http://127.0.0.1:5100/
