import requests
import json

# 設定値
api_endpoint = "http://localhost/v1/workflows/run" # DifyアプリのAPIエンドポイントURL
api_key = "app-xxx" # あなたのDify APIキー
user_id = "python-user-001"

memo = input('メモを記入：')
headers = {
  "Authorization": f"Bearer {api_key}",
  "Content-Type": "application/json"
}

data = {
  "inputs": {
    "memo_text": memo # 開始ノードで定義した変数名に合わせる
  },
  "response_mode": "blocking", # または "streaming"
  "user": user_id
}

try:
  response = requests.post(api_endpoint, headers=headers, json=data)
  response.raise_for_status() # エラーがあれば例外を発生させる

  result = response.json()
  print("API呼び出し成功:")
  # print(json.dumps(result, indent=2, ensure_ascii=False))

  # 回答部分を取り出す (レスポンスの構造に合わせて調整が必要)
  answer = result["data"]["outputs"]
  if answer:
    print(json.dumps(answer, indent=2, ensure_ascii=False))

except requests.exceptions.RequestException as e:
  print(f"API呼び出しエラー: {e}")
  if e.response is not None:
    print(f"ステータスコード: {e.response.status_code}")
    try:
      print(f"エラー詳細: {e.response.json()}")
    except json.JSONDecodeError:
      print(f"エラー詳細 (テキスト): {e.response.text}")
